/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.databind.api;

import io.gitlab.jfronny.commons.serialize.MalformedDataException;
import io.gitlab.jfronny.commons.serialize.SerializeReader;
import io.gitlab.jfronny.commons.serialize.SerializeWriter;

public abstract class TypeAdapter<T> {
    public abstract <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(T var1, Writer var2) throws TEx, MalformedDataException;

    public abstract <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> T deserialize(Reader var1) throws TEx, MalformedDataException;

    public final TypeAdapter<T> nullSafe() {
        return new TypeAdapter<T>(){

            @Override
            public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(T value, Writer writer) throws TEx, MalformedDataException {
                if (value == null) {
                    writer.nullValue();
                } else {
                    TypeAdapter.this.serialize(value, writer);
                }
            }

            @Override
            public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> T deserialize(Reader reader) throws TEx, MalformedDataException {
                if (reader.peek() == null) {
                    reader.nextNull();
                    return null;
                }
                return TypeAdapter.this.deserialize(reader);
            }
        };
    }

    public final TypeAdapter<T> viewWrapped() {
        return new TypeAdapter<T>(){

            @Override
            public <TEx extends Exception, Writer extends SerializeWriter<TEx, ?>> void serialize(T value, Writer writer) throws TEx, MalformedDataException {
                try (SerializeWriter<TEx, ?> view = writer.createView();){
                    TypeAdapter.this.serialize(value, view);
                }
            }

            @Override
            public <TEx extends Exception, Reader extends SerializeReader<TEx, ?>> T deserialize(Reader reader) throws TEx, MalformedDataException {
                try (SerializeReader<TEx, ?> view = reader.createView();){
                    Object t = TypeAdapter.this.deserialize(view);
                    return t;
                }
            }
        };
    }
}

